/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.IPlayer;
import dev.kosmx.playerAnim.api.layered.AnimationContainer;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.opennbs.format.Layer;
import dev.kosmx.playerAnim.core.util.Vec3d;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class EmotePlayerMixin
extends Player
implements IPlayerEntity<ModelPart> {
    int emotes_age = 0;
    @Shadow
    @Final
    public ClientLevel f_108545_;
    AnimationContainer<EmotePlayer<ModelPart>> emotecraftEmoteContainer = new AnimationContainer(null);
    boolean isForced = false;

    public EmotePlayerMixin(Level world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void emotecraft_init(ClientLevel clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        ((IPlayer)this).getAnimationStack().addAnimLayer(1000, this.emotecraftEmoteContainer);
    }

    @Override
    public void playEmote(KeyframeAnimation emote, int t, boolean isForced) {
        this.emotecraftEmoteContainer.setAnim((IAnimation)new EmotePlayImpl(emote, this::noteConsumer, t));
        this.initEmotePerspective((EmotePlayer)this.emotecraftEmoteContainer.getAnim());
        if (this.isMainPlayer()) {
            this.isForced = isForced;
        }
    }

    private void noteConsumer(Layer.Note note) {
        this.f_108545_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), EmotePlayerMixin.getInstrumentFromCode(note.instrument).m_61668_(), SoundSource.PLAYERS, note.getVolume(), note.getPitch(), true);
    }

    private static NoteBlockInstrument getInstrumentFromCode(byte b) {
        NoteBlockInstrument[] instruments = new NoteBlockInstrument[]{NoteBlockInstrument.HARP, NoteBlockInstrument.BASS, NoteBlockInstrument.BASEDRUM, NoteBlockInstrument.SNARE, NoteBlockInstrument.HAT, NoteBlockInstrument.GUITAR, NoteBlockInstrument.FLUTE, NoteBlockInstrument.BELL, NoteBlockInstrument.CHIME, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.IRON_XYLOPHONE, NoteBlockInstrument.COW_BELL, NoteBlockInstrument.DIDGERIDOO, NoteBlockInstrument.BIT, NoteBlockInstrument.BANJO, NoteBlockInstrument.PLING};
        if (b >= 0 && b < instruments.length) {
            return instruments[b];
        }
        return NoteBlockInstrument.HARP;
    }

    @Override
    public int emotes_getAge() {
        return this.emotes_age;
    }

    @Override
    public int emotes_getAndIncreaseAge() {
        return this.emotes_age++;
    }

    @Override
    public void voidEmote() {
        this.emotecraftEmoteContainer.setAnim(null);
    }

    @Override
    @Nullable
    public EmotePlayer<ModelPart> getEmote() {
        return (EmotePlayer)this.emotecraftEmoteContainer.getAnim();
    }

    @Override
    public UUID emotes_getUUID() {
        return this.m_142081_();
    }

    @Override
    public boolean isNotStanding() {
        return this.m_20089_() != Pose.STANDING;
    }

    @Override
    public Vec3d emotesGetPos() {
        return new Vec3d(Double.valueOf(this.m_20185_()), Double.valueOf(this.m_20186_()), Double.valueOf(this.m_20189_()));
    }

    @Override
    public Vec3d getPrevPos() {
        return new Vec3d(Double.valueOf(this.f_19854_), Double.valueOf(this.f_19855_), Double.valueOf(this.f_19856_));
    }

    @Override
    public float getBodyYaw() {
        return this.f_20883_;
    }

    @Override
    public float getViewYaw() {
        return this.f_20885_;
    }

    @Override
    public void setBodyYaw(float newYaw) {
        this.f_20883_ = newYaw;
    }

    public void m_8119_() {
        super.m_8119_();
        this.emoteTick();
    }

    @Override
    public boolean isForcedEmote() {
        return this.isPlayingEmote() && this.isForced;
    }
}

